% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation-indices.R
\name{calculate_PRCPstats}
\alias{calculate_PRCPstats}
\title{Calculate annual precipitation totals and statistics}
\usage{
calculate_PRCPstats(
  df,
  frequency = "daily",
  time_col = NULL,
  prcp_col = NULL,
  precip_col = NULL,
  wet_threshold = 1
)
}
\arguments{
\item{df}{Data frame with precipitation data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). Must be in a format recognizable by lubridate
(e.g., Date for daily data, POSIXct for hourly data). Recommended formats:
- Daily: YYYY-MM-DD (e.g., "2023-01-15")
- Hourly: YYYY-MM-DD HH:MM:SS (e.g., "2023-01-15 14:30:00")}

\item{prcp_col}{Name of precipitation column (daily data) (string)}

\item{precip_col}{Name of precipitation column (hourly data) (string)}

\item{wet_threshold}{Threshold for wet day in mm (default: 1)}
}
\value{
A data.frame with columns: year, PRCP_total, PRCP_days, PRCP_mean, PRCP_max
}
\description{
Calculates comprehensive annual precipitation statistics including
total precipitation, number of wet days, mean daily precipitation,
and maximum daily precipitation.
}
\examples{
# Daily precipitation data
daily_prcp <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  rainfall = pmax(0, rgamma(1096, shape = 0.5, scale = 10))
)

# Calculate comprehensive precipitation statistics
calculate_PRCPstats(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall"
)

# With custom wet threshold (2mm instead of 1mm)
calculate_PRCPstats(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall",
  wet_threshold = 2
)

# Hourly precipitation data (converted to daily)
hourly_prcp <- data.frame(
  datetime = seq(
    as.POSIXct("2000-01-01 00:00", tz = "UTC"),
    as.POSIXct("2000-01-31 23:00", tz = "UTC"),
    by = "hour"
  ),
  precip = pmax(0, rgamma(31*24, shape = 0.3, scale = 2))
)

calculate_PRCPstats(
  df = hourly_prcp,
  frequency = "hourly",
  time_col = "datetime",
  precip_col = "precip"
)
}
