% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_DTR}
\alias{calculate_DTR}
\title{Calculate diurnal temperature range (DTR)}
\usage{
calculate_DTR(
  df,
  frequency = "daily",
  time_col = NULL,
  tmax_col = NULL,
  tmin_col = NULL,
  temp_col = NULL
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmax_col}{Name of maximum temperature column (daily data) (string)}

\item{tmin_col}{Name of minimum temperature column (daily data) (string)}

\item{temp_col}{Name of temperature column (hourly data) (string)}
}
\value{
A tibble with columns: year, DTR_mean, DTR_sd, n_days
}
\description{
Calculates the mean and standard deviation of daily temperature range
(difference between maximum and minimum temperature) per year.
}
\examples{
# Daily data with maximum and minimum temperature
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmax = rnorm(1096, mean = 25, sd = 5),
  tmin = rnorm(1096, mean = 15, sd = 5)
)

calculate_DTR(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax",
  tmin_col = "tmin"
)
}
