% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privacy_budget.R
\name{new_privacy_budget}
\alias{new_privacy_budget}
\title{Create a New Privacy Budget}
\usage{
new_privacy_budget(epsilon_total, delta_total = 1e-05, composition = "basic")
}
\arguments{
\item{epsilon_total}{Total epsilon budget available}

\item{delta_total}{Total delta budget available (default: 1e-5)}

\item{composition}{Method for budget composition: "basic" or "advanced" (default: "basic")}
}
\value{
A privacy budget object (list with class "privacy_budget")
}
\description{
Initializes a privacy budget tracker for managing epsilon and delta across multiple
differentially private operations. The budget uses composition theorems to track
cumulative privacy loss.
}
\examples{
budget <- new_privacy_budget(epsilon_total = 1.0, delta_total = 1e-5)
}
