% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-sse.R
\name{sse_within_total}
\alias{sse_within_total}
\alias{sse_within_total.cluster_spec}
\alias{sse_within_total.cluster_fit}
\alias{sse_within_total.workflow}
\alias{sse_within_total_vec}
\title{Compute the sum of within-cluster SSE}
\usage{
sse_within_total(object, ...)

\method{sse_within_total}{cluster_spec}(object, ...)

\method{sse_within_total}{cluster_fit}(object, new_data = NULL, dist_fun = NULL, ...)

\method{sse_within_total}{workflow}(object, new_data = NULL, dist_fun = NULL, ...)

sse_within_total_vec(
  object,
  new_data = NULL,
  dist_fun = function(x, y) {
     philentropy::dist_many_many(x, y, method =
    "euclidean")
 },
  ...
)
}
\arguments{
\item{object}{A fitted kmeans tidyclust model}

\item{...}{Other arguments passed to methods.}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dist_fun}{A function for calculating distances to centroids. Defaults
to Euclidean distance on processed data.}
}
\value{
A tibble with 3 columns; \code{.metric}, \code{.estimator}, and \code{.estimate}.
}
\description{
Compute the sum of within-cluster SSE
}
\details{
Not to be confused with \code{\link[=sse_within]{sse_within()}} that returns a tibble
with within-cluster SSE, one row for each cluster.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

sse_within_total(kmeans_fit)

sse_within_total_vec(kmeans_fit)
}
\seealso{
Other cluster metric: 
\code{\link{silhouette_avg}()},
\code{\link{sse_ratio}()},
\code{\link{sse_total}()}
}
\concept{cluster metric}
