% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_frequency.R
\name{summarise_frequency}
\alias{summarise_frequency}
\title{Summarise Frequency Table}
\usage{
summarise_frequency(
  data,
  select = NULL,
  as_percent = FALSE,
  sort_by = NULL,
  top_n = Inf
)
}
\arguments{
\item{data}{A character/factor vector, or a data frame/tibble.}

\item{select}{Optional. One or more variable names to compute frequencies for. If NULL, all factor/character columns are used.}

\item{as_percent}{Logical. If TRUE, relative frequencies are returned as percentages (\%). Default is FALSE (proportions).}

\item{sort_by}{Optional. If "N", sorts by frequency; if "group", sorts alphabetically; or "\%N" (if as_percent = TRUE). 
Default is no sorting.}

\item{top_n}{Integer. Show only the top N values}
}
\value{
A tibble with the following columns:
\describe{
  \item{variable}{The name of the variable.}
  \item{group}{The group/category values of the variable.}
  \item{N}{The count (frequency) of each group.}
  \item{\%N}{The proportion or percentage of each group.}
}
}
\description{
Computes the frequency and relative frequency (or percentage) of factor or character variables in a data frame or vector.
}
\examples{
summarise_frequency(iris, select = "Species")
summarise_frequency(iris, as_percent = TRUE, sort_by = "N", top_n = 2)
summarise_frequency(data.frame(group = c("A", "A", "B", "C", "A")), as_percent = TRUE)

}
