% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_manifest.R
\name{ild_manifest}
\alias{ild_manifest}
\title{Create a reproducibility manifest}
\usage{
ild_manifest(
  seed = NULL,
  scenario = NULL,
  include_session = TRUE,
  include_git = FALSE,
  git_path = "."
)
}
\arguments{
\item{seed}{Optional integer. Seed used for the run (e.g. from
[ild_simulate()] or set before fitting). Not captured automatically;
pass explicitly if you want it in the manifest.}

\item{scenario}{Optional. Named list or character string describing the
run (e.g. formula, n_obs, n_id, ar1). Build from [ild_summary()] or
a short list when calling after [ild_lme()] / [ild_diagnostics()].}

\item{include_session}{Logical. If `TRUE` (default), include
[utils::sessionInfo()] in the manifest. Set to `FALSE` to reduce size.}

\item{include_git}{Logical. If `TRUE`, attempt to record the current
git commit SHA from \code{git_path}. Default `FALSE`.}

\item{git_path}{Character. Path to the repository root (default
\code{"."}). Used only when \code{include_git = TRUE}.}
}
\value{
A list with elements \code{timestamp} (POSIXct), \code{seed}
  (integer or NULL), \code{scenario} (as provided or NULL),
  \code{session_info} (list from sessionInfo() or NULL),
  \code{git_sha} (length-1 character or NA). All elements are
  serializable.
}
\description{
Captures timestamp, optional seed, optional scenario fingerprint,
session info, and optional git SHA for use when saving or serializing
results (e.g. after [ild_lme()] or [ild_diagnostics()]). The return
value is a serializable list suitable for [saveRDS()] or [ild_bundle()].
}
\examples{
m <- ild_manifest()
names(m)
m <- ild_manifest(seed = 42, scenario = list(n_obs = 100, formula = "y ~ x"))
m$seed
m$scenario
}
