% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_calling_dada.R
\name{variant_calling_dada}
\alias{variant_calling_dada}
\alias{variant_call_dada}
\alias{loess_err_mod4}
\alias{chimera_removal}
\alias{dada2list}
\title{Variant calling using DADA2 ASV approach}
\usage{
variant_call_dada(
  locus,
  in_dir,
  fw_pattern = "_F_filt.fastq.gz",
  rv_pattern = NULL,
  sample_locus = "(^[a-zA-Z0-9]*)_([a-zA-Z0-9]*)",
  c_unmerged = FALSE,
  pool = FALSE,
  error_function = loessErrfun,
  multithread = FALSE,
  chim_rm = "consensus",
  omega_a_f = getDadaOpt()$OMEGA_A,
  omega_a_r = getDadaOpt()$OMEGA_A,
  band_size = getDadaOpt()$BAND_SIZE
)

loess_err_mod4(trans)

chimera_removal(seqtab, chim_rm)

dada2list(dada_object, names)
}
\arguments{
\item{locus}{Locus name.}

\item{in_dir}{Path to folder with truncated files.}

\item{fw_pattern}{Pattern matching files with F reads.}

\item{rv_pattern}{Pattern matching files with R reads. If left NULL,
single-end sequencing will be assumed.}

\item{sample_locus}{Patterns to extract from FASTQ file names.
Group 1 captures
sample name and group 2 captures locus name.
(DEFAULT: \verb{(^[a-zA-Z0-9]*)_([a-zA-Z0-9]*)}).
\verb{^[a-zA-Z0-9]*_[a-zA-Z0-9]*} will extract 'sample_locus'
from default naming convention \verb{sample_locus_[F|R]_fastq.gz}.}

\item{c_unmerged}{F/R sequences that were not merged in mergePairs
are concatenated using a stretch of 10 N's.}

\item{pool}{Passed to 'dada()'. Denoising is done in pooled samples
(T) or by sample (F).}

\item{error_function}{Use default 'loessErrfun()' for regular
Illumina quality codification and 'loess_err_mod4()' for binned NovaSeq
qualities. Passed to 'dada(errorEstimationFunction)'.}

\item{multithread}{T/F, passed to 'dada(multithread)' and
'learnErrors(multithread)'.}

\item{chim_rm}{If FALSE, no chimera removal is performed. If chim_rm  is
"character", it is passed to 'removeBimeraDenovo(method)'.}

\item{omega_a_f}{"OMEGA_A" passed to 'dada' in forward reads
(Default: 'getDadaOpt()$OMEGA_A').}

\item{omega_a_r}{"OMEGA_A" passed to 'dada' in reverse reads
(Default: 'getDadaOpt()$OMEGA_A').}

\item{band_size}{"BAND_SIZE" passed to 'dada'
(DEFAULT: 'getDadaOpt()$BAND_SIZE').}

\item{trans}{See loessErrfun for details.}

\item{seqtab}{Features table from dada2.}

\item{dada_object}{Object from \code{\link[dada2:dada]{dada2::dada()}}, \code{\link[dada2:mergePairs]{dada2::mergePairs()}}, etc.}

\item{names}{Character vector to name the elements in the list. By default,
DADA2 names are basenames from FAST(Q).}
}
\value{
\itemize{
\item 'variant_call_dada()' Numeric array. Column names are variant sequences;
row names are sample names and each number in the array indicate
the number of reads supporting variant 'i' in sample 'j'.
}

\itemize{
\item 'chimera_removal()' 'seqtab' like object (see dada2).
}

\itemize{
\item 'dada2list()' List with dada2 object/s.
}
}
\description{
\itemize{
\item 'variant_call_dada()' Call variants for a single locus using DADA2.
It is nested in 'variant_call'.
}

\itemize{
\item 'loess_err_mod4()' Replaces default 'loessErrfun' when estimating error
matrices for NovaSeq binned qualities.
}

\itemize{
\item 'chimera_removal()' Wrapping function to remove chimeras
using 'removeBimeraDenovo()'.
}
}
\details{
\itemize{
\item 'variant_call_dada()' Allows single-end and paired-end data.
'c_unmerged' will trigger the 'justConcatenate' argument in 'mergePairs',
and 10 N's will be used to concatenate non-overlapping F and R reads.
Use 'concateNotMerged' carefully, as it will generate artificial variant
sequences. Default is deactivated.
}

\itemize{
\item 'loess_err_mod4()' This is a beta function which has been shown to work
in my experience and other users' experience.
See discussion in https://github.com/benjjneb/dada2/issues/1307
}

\itemize{
\item 'dada2list()' DADA2 functions return a dataframe whenever
the length of the object
is == 1 or a list if length > 1. To smooth prevent from bugs, this function
standardizes the output of dada2 to lists when length == 1.
Unaltered when input is a list.
}
}
