% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_features.R
\name{calculate_features}
\alias{calculate_features}
\title{Compute features on an input time series dataset}
\usage{
calculate_features(
  data,
  feature_set = c("catch22", "feasts", "tsfeatures", "kats", "tsfresh", "tsfel",
    "quantiles", "moments"),
  features = NULL,
  catch24 = FALSE,
  tsfresh_cleanup = FALSE,
  use_compengine = FALSE,
  seed = 123,
  z_score = FALSE,
  n_jobs = 0,
  warn = TRUE
)
}
\arguments{
\item{data}{\code{tbl_ts} containing the time series data}

\item{feature_set}{\code{character} or \code{vector} of \code{character} denoting the set of time-series features to calculate. Can be one of \code{"catch22"}, \code{"feasts"}, \code{"tsfeatures"}, \code{"tsfresh"}, \code{"tsfel"}, \code{"kats"}, \code{"quantiles"}, and or \code{"moments"}}

\item{features}{named \code{list} containing a set of user-supplied functions to calculate on \code{data}. Each function should take a single argument which is the time series. Defaults to \code{NULL} for no manually-specified features. Each list entry must have a name as \code{calculate_features} looks for these to name the features. If you don't want to use the existing feature sets and only compute those passed to \code{features}, set \code{feature_set = NULL}}

\item{catch24}{\code{Boolean} specifying whether to compute \code{catch24} in addition to \code{catch22} if \code{catch22} is one of the feature sets selected. Defaults to \code{FALSE}}

\item{tsfresh_cleanup}{\code{Boolean} specifying whether to use the in-built \code{tsfresh} relevant feature filter or not. Defaults to \code{FALSE}}

\item{use_compengine}{\code{Boolean} specifying whether to use the \code{"compengine"} features in \code{tsfeatures}. Defaults to \code{FALSE} to provide immense computational efficiency benefits}

\item{seed}{\code{integer} denoting a fixed number for R's random number generator to ensure reproducibility. Defaults to \code{123}}

\item{z_score}{\code{Boolean} specifying whether to z-score the time-series before computing features. Defaults to \code{FALSE}}

\item{n_jobs}{\code{integer} denoting the number of parallel processes to use if \code{"tsfresh"} or \code{"tsfel"} are specified in \code{"feature_set"}. Defaults to \code{0} for no parallelisation}

\item{warn}{\code{Boolean} specifying whether to produce warnings from feature set packages. Defaults to \code{TRUE}}
}
\value{
object of class \code{feature_calculations} that contains the summary statistics for each feature
}
\description{
Compute features on an input time series dataset
}
\examples{
featMat <- calculate_features(data = simData, 
  feature_set = "catch22")

}
\author{
Trent Henderson
}
