% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_power_spherical}
\alias{tfd_power_spherical}
\title{The Power Spherical distribution over unit vectors on \code{S^{n-1}}.}
\usage{
tfd_power_spherical(
  mean_direction,
  concentration,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "PowerSpherical"
)
}
\arguments{
\item{mean_direction}{Floating-point \code{Tensor} with shape \verb{[B1, ... Bn, N]}.
A unit vector indicating the mode of the distribution, or the
unit-normalized direction of the mean.}

\item{concentration}{Floating-point \code{Tensor} having batch shape \verb{[B1, ... Bn]}
broadcastable with \code{mean_direction}. The level of concentration of
samples around the \code{mean_direction}. \code{concentration=0} indicates a
uniform distribution over the unit hypersphere, and \code{concentration=+inf}
indicates a \code{Deterministic} distribution (delta function) at
\code{mean_direction}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The Power Spherical distribution is a distribution over vectors
on the unit hypersphere \code{S^{n-1}} embedded in \code{n} dimensions (\code{R^n}).
It serves as an alternative to the von Mises-Fisher distribution with a
simpler (faster) \code{log_prob} calculation, as well as a reparameterizable
sampler. In contrast, the Power Spherical distribution does have
-\code{mean_direction} as a point with zero density (and hence a neighborhood
around that having arbitrarily small density), in contrast with the
von Mises-Fisher distribution which has non-zero density everywhere.
NOTE: \code{mean_direction} is not in general the mean of the distribution. For
spherical distributions, the mean is generally not in the support of the
distribution.
}
\details{
Mathematical details

The probability density function (pdf) is,

\if{html}{\out{<div class="sourceCode">}}\preformatted{pdf(x; mu, kappa) = C(kappa) (1 + mu^T x) ** k
  where,
     C(kappa) = 2**(a + b) pi**b Gamma(a) / Gamma(a + b)
     a = (n - 1) / 2. + k
     b = (n - 1) / 2.
}\if{html}{\out{</div>}}

where
\itemize{
\item \code{mean_direction = mu}; a unit vector in \code{R^k},
\item \code{concentration = kappa}; scalar real >= 0, concentration of samples around
\code{mean_direction}, where 0 pertains to the uniform distribution on the
hypersphere, and \verb{\\inf} indicates a delta function at \code{mean_direction}.
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
