% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_continuous_bernoulli}
\alias{tfd_continuous_bernoulli}
\title{Continuous Bernoulli distribution.}
\usage{
tfd_continuous_bernoulli(
  logits = NULL,
  probs = NULL,
  dtype = tf$float32,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "ContinuousBernoulli"
)
}
\arguments{
\item{logits}{An N-D \code{Tensor}. Each entry in the \code{Tensor} parameterizes
an independent continuous Bernoulli distribution with parameter
sigmoid(logits). Only one of \code{logits} or \code{probs} should be passed
in. Note that this does not correspond to the log-odds as in the
Bernoulli case.}

\item{probs}{An N-D \code{Tensor} representing the parameter of a continuous
Bernoulli. Each entry in the \code{Tensor} parameterizes an independent
continuous Bernoulli distribution. Only one of \code{logits} or \code{probs}
should be passed in. Note that this also does not correspond to a
probability as in the Bernoulli case.}

\item{dtype}{The type of the event samples. Default: \code{float32}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
This distribution is parameterized by \code{probs}, a (batch of) parameters
taking values in \verb{(0, 1)}. Note that, unlike in the Bernoulli case, \code{probs}
does not correspond to a probability, but the same name is used due to the
similarity with the Bernoulli.
}
\details{
Mathematical Details

The continuous Bernoulli is a distribution over the interval \verb{[0, 1]},
parameterized by \code{probs} in \verb{(0, 1)}.
The probability density function (pdf) is,

\if{html}{\out{<div class="sourceCode">}}\preformatted{pdf(x; probs) = probs**x * (1 - probs)**(1 - x) * C(probs)
C(probs) = (2 * atanh(1 - 2 * probs) / (1 - 2 * probs) if probs != 0.5 else 2.)
}\if{html}{\out{</div>}}

While the normalizing constant \code{C(probs)} is a continuous function of \code{probs}
(even at \code{probs = 0.5}), computing it at values close to 0.5 can result in
numerical instabilities due to 0/0 errors. A Taylor approximation of
\code{C(probs)} is thus used for values of \code{probs}
in a small interval \verb{[lims[0], lims[1]]} around 0.5. For more details,
see Loaiza-Ganem and Cunningham (2019).
NOTE: Unlike the Bernoulli, numerical instabilities can happen for \code{probs}
very close to 0 or 1. Current implementation allows any value in \verb{(0, 1)},
but this could be changed to \verb{(1e-6, 1-1e-6)} to avoid these issues.
}
\section{References}{

\itemize{
\item Loaiza-Ganem G and Cunningham JP. The continuous Bernoulli: fixing a
pervasive error in variational autoencoders. NeurIPS2019.
https://arxiv.org/abs/1907.06845
}
}

\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
