% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_take_while}
\alias{dataset_take_while}
\title{A transformation that stops dataset iteration based on a predicate.}
\usage{
dataset_take_while(dataset, predicate, name = NULL)
}
\arguments{
\item{dataset}{A TF dataset}

\item{predicate}{A function that maps a nested structure of tensors (having
shapes and types defined by \code{self$output_shapes} and \code{self$output_types})
to a scalar \code{tf.bool} tensor.}

\item{name}{(Optional.) A name for the tf.data operation.}
}
\value{
A TF Dataset
}
\description{
A transformation that stops dataset iteration based on a predicate.
}
\details{
Example usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ range_dataset(from = 0, to = 10) \%>\%
   dataset_take_while( ~ .x < 5) \%>\%
   as_array_iterator() \%>\%
   iterate(simplify = FALSE) \%>\% str()
 #> List of 5
 #> $ : num 0
 #> $ : num 1
 #> $ : num 2
 #> $ : num 3
 #> $ : num 4
}\if{html}{\out{</div>}}
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_rebatch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
