% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_options}
\alias{dataset_options}
\title{Get or Set Dataset Options}
\usage{
dataset_options(dataset, ...)
}
\arguments{
\item{dataset}{a tensorflow dataset}

\item{...}{Valid values include:
\itemize{
\item A set of named arguments setting options. Names of nested attributes can
be separated with a \code{"."} (see examples). The set of named arguments can be
supplied individually to \code{...}, or as a single named list.
\item a \code{tf$data$Options()} instance.
}}
}
\value{
If values are supplied to \code{...}, returns a \code{tf.data.Dataset} with the
given options set/updated. Otherwise, returns the currently set options for
the dataset.
}
\description{
Get or Set Dataset Options
}
\details{
The options are "global" in the sense they apply to the entire
dataset. If options are set multiple times, they are merged as long as
different options do not use different non-default values.
}
\examples{
\dontrun{
# pass options directly:
range_dataset(0, 10) \%>\%
  dataset_options(
    experimental_deterministic = FALSE,
    threading.private_threadpool_size = 10
  )

# pass options as a named list:
opts <- list(
  experimental_deterministic = FALSE,
  threading.private_threadpool_size = 10
)
range_dataset(0, 10) \%>\%
  dataset_options(opts)

# pass a tf.data.Options() instance
opts <- tf$data$Options()
opts$experimental_deterministic <- FALSE
opts$threading$private_threadpool_size <- 10L
range_dataset(0, 10) \%>\%
  dataset_options(opts)

# get currently set options
range_dataset(0, 10) \%>\% dataset_options()
}
}
