% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_filter}
\alias{dataset_filter}
\title{Filter a dataset by a predicate}
\usage{
dataset_filter(dataset, predicate)
}
\arguments{
\item{dataset}{A dataset}

\item{predicate}{A function mapping a nested structure of tensors (having
shapes and types defined by \code{\link[=output_shapes]{output_shapes()}} and \code{\link[=output_types]{output_types()}} to a
scalar \code{tf$bool} tensor.}
}
\value{
A dataset composed of records that matched the predicate.
}
\description{
Filter a dataset by a predicate
}
\details{
Note that the functions used inside the predicate must be
tensor operations (e.g. \code{tf$not_equal}, \code{tf$less}, etc.). R
generic methods for relational operators (e.g. \code{<}, \code{>}, \code{<=},
etc.) and logical operators (e.g. \code{!}, \code{&}, \code{|}, etc.) are
provided so you can use shorthand syntax for most common
comparisions (this is illustrated by the example below).
}
\examples{
\dontrun{

dataset <- text_line_dataset("mtcars.csv", record_spec = mtcars_spec) \%>\%
  dataset_filter(function(record) {
    record$mpg >= 20
})

dataset <- text_line_dataset("mtcars.csv", record_spec = mtcars_spec) \%>\%
  dataset_filter(function(record) {
    record$mpg >= 20 & record$cyl >= 6L
  })

}

}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_rebatch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_take_while}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
