% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{tf}
\alias{tf}
\title{Transfer function for input}
\usage{
tf(
  x = NULL,
  delay = 0,
  w0 = 0.01,
  ar = NULL,
  ma = NULL,
  um = NULL,
  n.back = NULL,
  par.prefix = "",
  envir = parent.frame()
)
}
\arguments{
\item{x}{Input time series. A ts object or numeric vector. If NULL, input
should be provided inside the \code{um} object.}

\item{delay}{Integer. Number of periods to delay the input (d in the transfer
function).}

\item{w0}{Numeric. Constant term of the transfer function polynomial V(B).}

\item{ar}{Character string or list. Specification of autoregressive
polynomials in the denominator.}

\item{ma}{Character string or list. Specification of moving average
polynomials in the numerator.}

\item{um}{Univariate model object. Model for the stochastic component of the
input series.}

\item{n.back}{Integer. Number of backcasts to compute for extending the input
series backward.}

\item{par.prefix}{Character. Prefix for parameter names in transfer function.}

\item{envir}{Environment. Environment for evaluating function arguments. If
NULL, uses the calling environment.}
}
\value{
An object of class "tf" containing the transfer function specification.
Key components include:
\describe{
  \item{x}{Input time series data (possibly extended with backcasts).}
  \item{delay}{Number of periods delay in the transfer function.}
  \item{w0}{Constant gain parameter.}
  \item{phi}{AR polynomial coefficients (denominator).}
  \item{theta}{MA polynomial coefficients (numerator).}
  \item{p, q}{Orders of AR and MA polynomials respectively.}
  \item{param}{Named list of all model parameters.}
  \item{um}{Univariate model for the input series.}
}
}
\description{
\code{tf} creates a rational transfer function for an input, V(B) = w0(1 -
w_1B - ... - w_qB^q)/(1-d_1B - ... - d_pB^p)B^dX_t. Note that in this
specification the constant term of the MA polynomial is factored out so that
both polynomials in the numerator and denominator are normalized and can be
specified with the \code{lagpol} function in the same way as the operators of
univariate models.
}
\examples{

x <- rep(0, 100)
x[50] <- 1
tfx <- tf(x, w0 = 0.8, ar = "(1 - 0.5B)(1 - 0.7B^12)")

}
\references{
Box, G.E., Jenkins, G.M., Reinsel, G.C. and Ljung, G.M. (2015) Time Series
Analysis: Forecasting and Control. John Wiley & Sons, Hoboken.

Wei, W.W.S. (2006) Time Series Analysis Univariate and Multivariate Methods.
2nd Edition, Addison Wesley, New York, 33-59.
}
\seealso{
\code{\link{um}}.
}
