% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{signal}
\alias{signal}
\alias{signal.tfm}
\title{Signal component of a TF model}
\usage{
signal(mdl, ...)

\method{signal}{tfm}(
  mdl,
  y = NULL,
  diff = FALSE,
  type = c("xreg", "inputs"),
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{mdl}{an object of the class \code{tfm}.}

\item{...}{additional arguments.}

\item{y}{output of the TF model if it is different to that of the \code{tfm}
object.}

\item{diff}{logical. If TRUE, the signal is differenced with the "i" operator
of the univariate model of the noise.}

\item{type}{Character vector specifying signal components to extract: "xreg"
for exogenous regressors only,"inputs" for transfer function inputs only.
If both provided (default), includes all components.}

\item{envir}{Environment in which the function arguments are evaluated. By
default, the calling environment is used.}
}
\value{
A "ts" object.
}
\description{
\code{signal} extracts the signal of a TF model.
}
