% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{fit.tfm}
\alias{fit.tfm}
\title{Fit a Transfer Function Model}
\usage{
\method{fit}{tfm}(
  mdl,
  y = NULL,
  method = c("exact", "cond"),
  optim.method = "BFGS",
  show.iter = FALSE,
  fit.noise = TRUE,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{An object of class \code{tfm} created with \code{\link{tfm}}.}

\item{y}{Optional \code{ts} object containing the output series. If
\code{NULL}, the output stored in \code{noise} is used.}

\item{method}{Character string specifying likelihood method: "exact" for
exact maximum likelihood or "cond" for conditional maximum likelihood.
Default is "exact".}

\item{optim.method}{Character. Optimization method passed to
\code{\link{optim}}. Default is \code{"BFGS"}. Other options:
"Nelder-Mead", "CG", "L-BFGS-B".}

\item{show.iter}{Logical. If \code{TRUE}, prints iteration progress of the
likelihood optimization.}

\item{fit.noise}{Logical. If \code{TRUE} (default), the parameters of the
noise model are estimated. If \code{FALSE}, noise parameters are fixed at
their current values.}

\item{envir}{Environment in which the function arguments are evaluated. If
\code{NULL}, the calling environment is used.}

\item{...}{Additional arguments.}
}
\value{
An updated object of class \code{tfm} containing fitted parameters,
  estimated innovation variance, and optimization details.
}
\description{
Estimates the parameters of a transfer function model of class \code{tfm} by
(conditional or exact) maximum likelihood.
}
\examples{
\dontrun{
data(seriesJ)
Y <- seriesJ$Y - mean(seriesJ$Y)
X <- seriesJ$X - mean(seriesJ$X)
umx <- um(X, ar = 3)
umy <- fit(umx, Y)
tfx <- tfest(Y, X, delay = 3, p = 2, q = 2, um.x = umx, um.y = umy)
tfmy <- tfm(Y, inputs = tfx, noise = um(ar = 2), fit = FALSE)
tfmy_fit <- fit(tfmy)
}
}
\seealso{
\code{\link{tfm}}
}
