% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{easter}
\alias{easter}
\alias{easter.um}
\title{Easter effect}
\usage{
easter(um, ...)

\method{easter}{um}(
  um,
  z = NULL,
  len = 4,
  easter.mon = FALSE,
  n.ahead = 0,
  envir = NULL,
  ...
)
}
\arguments{
\item{um}{an object of class \code{\link{um}}.}

\item{...}{other arguments.}

\item{z}{a time series.}

\item{len}{a positive integer specifying the duration of the Easter.}

\item{easter.mon}{logical. If TRUE Easter Monday is also taken into account.}

\item{n.ahead}{a positive integer to extend the sample period of the
Easter regression variable with \code{n.ahead} observations, which could be
necessary to forecast the output.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}
}
\value{
An object of class "\code{\link{tfm}}".
}
\description{
\code{easter} extends the ARIMA model \code{um} by including a regression
variable to capture the Easter effect.
}
\examples{
data(rsales)
um1 <- um(rsales, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
tfm1 <- easter(um1)
}
