% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_levels.R
\name{step_clean_levels}
\alias{step_clean_levels}
\alias{tidy.step_clean_levels}
\title{Clean Categorical Levels}
\usage{
step_clean_levels(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  clean = NULL,
  skip = FALSE,
  id = rand_id("clean_levels")
)
}
\arguments{
\item{recipe}{A \link[recipes:recipe]{recipes::recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{clean}{A named character vector to clean and recode categorical levels.
This is \code{NULL} until computed by \code{\link[recipes:prep]{recipes::prep.recipe()}}. Note that if the
original variable is a character vector, it will be converted to a factor.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_clean_levels()} creates a \emph{specification} of a recipe step that will
clean nominal data (character or factor) so the levels consist only of
letters, numbers, and the underscore.
}
\details{
The new levels are cleaned and then reset with \code{\link[dplyr:recode]{dplyr::recode_factor()}}. When
data to be processed contains novel levels (i.e., not contained in the
training set), they are converted to missing.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{orginal}, \code{value}, and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{original}{character, the original levels}
\item{value}{character, the cleaned levels}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("modeldata", "janitor"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(modeldata)
data(Smithsonian)

smith_tr <- Smithsonian[1:15, ]
smith_te <- Smithsonian[16:20, ]

rec <- recipe(~., data = smith_tr)

rec <- rec \%>\%
  step_clean_levels(name)
rec <- prep(rec, training = smith_tr)

cleaned <- bake(rec, smith_tr)

tidy(rec, number = 1)

# novel levels are replaced with missing
bake(rec, smith_te)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_clean_names]{step_clean_names()}}, \code{\link[recipes:step_factor2string]{recipes::step_factor2string()}},
\code{\link[recipes:step_string2factor]{recipes::step_string2factor()}}, \code{\link[recipes:step_regex]{recipes::step_regex()}},
\code{\link[recipes:step_unknown]{recipes::step_unknown()}}, \code{\link[recipes:step_novel]{recipes::step_novel()}}, \code{\link[recipes:step_other]{recipes::step_other()}}

Other Steps for Text Cleaning: 
\code{\link{step_clean_names}()}
}
\concept{Steps for Text Cleaning}
