% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuneHyperparameter.R
\name{tune_rf_model}
\alias{tune_rf_model}
\title{Tune Random Forest Model Hyperparameters}
\usage{
tune_rf_model(
  train_matrix,
  train_labels,
  mtry_grid = c(5, 10, 20),
  ntree_grid = c(100, 200, 300),
  seed = 123,
  verbose = TRUE
)
}
\arguments{
\item{train_matrix}{A sparse matrix (class `dgCMatrix`) representing the training feature data.}

\item{train_labels}{A factor vector representing the training labels.}

\item{mtry_grid}{A vector of values to search for the `mtry` parameter (number of variables to consider at each split). Default is `c(5, 10, 20)`.}

\item{ntree_grid}{A vector of values to search for the `ntree` parameter (number of trees in the forest). Default is `c(100, 200, 300)`.}

\item{seed}{A seed value for reproducibility. Default is `123`.}

\item{verbose}{A logical indicating whether to print progress information during the grid search. Default is `TRUE`.}
}
\value{
A list containing the best hyperparameters (`mtry`, `ntree`, and `accuracy`):
\itemize{
  \item `mtry`: The best number of variables to consider at each split.
  \item `ntree`: The best number of trees in the forest.
  \item `accuracy`: The accuracy achieved by the model with the best hyperparameters.
}
}
\description{
This function performs hyperparameter tuning for a Random Forest model using grid search.
It searches over the grid of `mtry` (number of variables to consider at each split) and `ntree`
(number of trees in the forest) to find the best model based on training accuracy.
}
\details{
The function trains multiple Random Forest models using different combinations of `mtry` and `ntree`
values, and evaluates their performance based on training accuracy. The hyperparameters that give
the highest accuracy are returned as the best parameters. The process uses the `ranger` package for
training the Random Forest model.
}
