% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-chk.R
\name{value-expectations}
\alias{value-expectations}
\alias{expect_values}
\alias{expect_range}
\title{Expectations: values}
\usage{
expect_values(
  vars,
  ...,
  miss = getOption("testdat.miss"),
  flt = TRUE,
  data = get_testdata()
)

expect_range(vars, min, max, ..., flt = TRUE, data = get_testdata())
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{...}{Vectors of valid values.}

\item{miss}{A vector of values to be treated as missing. The
\link[=testdat]{testdat.miss} or \link[=testdat]{testdat.miss_text} option is used by
default.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{min}{Minimum value for range check.}

\item{max}{Maximum value for range check.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
Test whether variables in a data frame contain only certain values.
}
\examples{

sales <- data.frame(
  sale_id = 1:5,
  date = c("20200101", "20200101", "20200102", "20200103", "20220101"),
  sale_price = c(10, 20, 30, 40, -1)
)

try(expect_values(date, 20000000:20210000, data = sales)) # Dates between 2000 and 2021
try(expect_range(sale_price, min = 0, max = Inf, data = sales)) # Prices non-negative

}
\seealso{
\link[=chk-values]{Checks: values}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}}
}
\concept{data expectations}
