% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{geom_azimuthpoint}
\alias{geom_azimuthpoint}
\title{Azimuth + point visualization}
\usage{
geom_azimuthpoint(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  center = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  size = 2,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame. If \code{NULL}, the default, the data is inherited from
the plot data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.}

\item{stat}{The statistical transformation to use on the data. Defaults to
\code{"identity"}.}

\item{center}{Logical; if \code{TRUE} spokes are centered on (x, y) using
\code{\link{PositionCenterSpoke}}. If \code{FALSE}, behaves like
\code{\link[ggplot2:geom_spoke]{ggplot2::geom_spoke()}} (line starts at (x, y)).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{size}{Size of the point marker (default = 2).}

\item{...}{Other arguments passed on to \code{\link[=geom_azimuth]{geom_azimuth()}} and
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}. These may include \code{arrow}, \code{fill}, etc.}
}
\value{
A list of ggplot2 layers (spokes + points).
}
\description{
\code{geom_azimuthpoint()} draws line segments (spokes) like \code{\link[=geom_azimuth]{geom_azimuth()}}, but also
places a point (marker) at the spoke's center \verb{(x, y)}.

Aesthetic rules:
\itemize{
\item \code{linewidth}, \code{linetype} affect the spoke only
\item \code{shape} affects the point only
\item \code{colour}, \code{alpha} affect both spoke and point
\item \code{size} sets the size of the point only
}
}
\section{Aesthetics}{

\code{geom_azimuthpoint()} understands the following aesthetics (required aesthetics in \strong{bold}):
\itemize{
\item \strong{x}
\item \strong{y}
\item angle (in degrees, transformed internally; spoke only)
\item radius (spoke only)
\item colour (shared)
\item alpha (shared)
\item linewidth (spoke only)
\item linetype (spoke only)
\item shape (point only)
\item size (point only, or via argument)
\item fill (point only, for shapes that accept fill)
}
}

\examples{
set.seed(20250411)
df <- data.frame(
  x = runif(5), y = runif(5),
  angle_deg = rvm(5, mean = 90, kappa = 10),
  radius = runif(5, 0.1, 1),
  group = rep(1:2, length.out = 5)
)

if (require("ggplot2")) {
  ggplot(data = df, aes(x, y, angle = angle_deg, radius = radius)) +
    geom_azimuthpoint(aes(colour = factor(group), shape = factor(group)),
      linewidth = 1.1, linetype = "dashed",
      size = 3, alpha = 0.8
    )
}

}
\seealso{
\code{\link[=geom_azimuth]{geom_azimuth()}}, \code{\link[ggplot2:geom_spoke]{ggplot2::geom_spoke()}}, \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}
}
