% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_shmax.R
\name{deviation_shmax}
\alias{deviation_shmax}
\title{Deviation of Observed and Predicted Directions of Maximum Horizontal Stress}
\usage{
deviation_shmax(prd, obs)
}
\arguments{
\item{prd}{\code{data.frame} containing the modeled azimuths of
\eqn{\sigma_{Hmax}}{SHmax}, i.e.
the return object from \code{model_shmax()}}

\item{obs}{Numeric vector containing the observed azimuth of
\eqn{\sigma_{Hmax}}{SHmax},
same length as \code{prd}}
}
\value{
An object of class \code{data.frame}

\describe{
\item{dev.gc}{Deviation of observed stress from modeled
\eqn{\sigma_{Hmax}}{SHmax} following
great circles}
\item{dev.sc}{Small circles}
\item{dev.ld.cw}{Clockwise loxodromes}
\item{dev.ld.ccw}{Counter-clockwise loxodromes}
}
}
\description{
Calculate the angular difference between the observed and modeled direction
of maximum horizontal stresses (\eqn{\sigma_{Hmax}}{SHmax}) along
great circles, small circles, and
loxodromes of the relative plate motion's Euler pole
}
\details{
Deviation is positive for counterclockwise deviation of observed azimuth wrt.
predicted azimuth.
}
\examples{
data("nuvel1")
# North America relative to Pacific plate:
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")

# the point where we want to model the SHmax direction:
point <- data.frame(lat = 45, lon = 20)

prd <- model_shmax(point, PoR)
deviation_shmax(prd, obs = 90)
}
\references{
Stephan, T., Enkelmann, E., and Kroner, U. "Analyzing the
horizontal orientation of the crustal stress adjacent to plate boundaries".
\emph{Sci Rep} 13. 15590 (2023). \doi{10.1038/s41598-023-42433-2}.
}
\seealso{
\code{\link[=model_shmax]{model_shmax()}} to calculate the theoretical direction of
\eqn{\sigma_{Hmax}}{SHmax}.
}
\author{
Tobias Stephan
}
