% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{inf_manual}
\alias{inf_manual}
\title{infusion schedule}
\usage{
inf_manual(inf_tms, inf_rate, duration = NULL)
}
\arguments{
\item{inf_tms}{Vector of time to begin infusions. If duration is NULL, times
expected to include both infusion start and infusion end times.}

\item{inf_rate}{Vector of infusion rates. Must lave length equal to either
length(inf_tms) or 1. If length(inf_rate)=1, the same infusion rate will be
administered at each time. Either inf_rate or target must be specified, but not both.}

\item{duration}{Optional duration of infusions.}
}
\value{
Matrix of infusion rates, start and end times.
}
\description{
Returns a data frame describing a set of infusions to be administered. Output
can be used as argument "inf" in predict_pkmod.
}
\examples{
# specify start and end times, as well as infusion rates (including 0).
inf_manual(inf_tms = c(0,0.5,4,4.5,10), inf_rate = c(100,0,80,0,0))
# specify start times, single infusion rate and single duration
inf_manual(inf_tms = c(0,4), inf_rate = 100, duration = 0.5)
# multiple infusion rates, single duration
inf_manual(inf_tms = c(0,4), inf_rate = c(100,80), duration = 0.5)
# multiple sequential infusion rates
inf_manual(inf_tms = seq(0,1,1/6), inf_rate = 100, duration = 1/6)
# single infusion rate, multiple durations
inf_manual(inf_tms = c(0,4), inf_rate = 100, duration = c(0.5,1))
# multiple infusion rates, multiple durations
inf_manual(inf_tms = c(0,4), inf_rate = c(100,80), duration = c(0.5,1))
}
