% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels.R
\name{levels}
\alias{levels}
\alias{levels.taxlist}
\alias{levels,taxlist-method}
\alias{levels<-}
\alias{levels<-.taxlist}
\alias{levels<-,taxlist-method}
\title{Set and retrieves hierarchical levels}
\usage{
levels(x)

\method{levels}{taxlist}(x)

levels(x) <- value

\method{levels}{taxlist}(x) <- value
}
\arguments{
\item{x}{A \linkS4class{taxlist} object.}

\item{value}{A character vector with replacement values for levels o \code{x}.}
}
\value{
A \code{character} vector or a \linkS4class{taxlist} object with
added or modified taxonomic levels.
}
\description{
Taxonomic hierarchies can be set as levels in \linkS4class{taxlist}
objects, ordered from lower to higher levels.

Add taxonomic levels for specific taxon concepts in a
\linkS4class{taxlist} object.
Also changes in concept circumscription may implicate changes in its
taxonomic hierarchy.
}
\details{
Taxonomic levels will be handled as factors in the
\linkS4class{taxlist} objects.
Those levels are useful for creating subsets of related groups (e.g. by
functions \code{\link[=get_children]{get_children()}} or \code{\link[=get_parents]{get_parents()}}).

Levels in combination to parent-child relationships will be further used for
checking consistency of taxonomic lists.

A replacement method of the form \code{levels(x) <- value} it is also implemented.
}
\examples{
## Get levels of species list
levels(Easplist)

## Add aggregate as new taxonomic level
levels(Easplist) <- c("form", "variety", "subspecies", "species", "complex",
    "aggregate", "genus", "family")
summary(Easplist)
}
\seealso{
\code{\link[=prune_levels]{prune_levels()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
