% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lines.R
\name{add_lines}
\alias{add_lines}
\title{Add information for line-by-line visualization}
\usage{
add_lines(data, time_columns = c("begin", "end"), line_duration = 60000)
}
\arguments{
\item{data}{dataset to divide into lines}

\item{time_columns}{columns with timestamps that need to be adjusted to line-relative time}

\item{line_duration}{length of line (in ms)}
}
\value{
data set with added columns: `line_id`, `line_participant`, and
       `line_column` for every column in `time_columns`
}
\description{
This function adds columns to the dataset that adds a line ID, and changes columns
with timestamps relative to the beginning of the line, so data can
be visualized line-by-line.
The participant column is also adjusted to create a Y-coordinate for each speaker.
The line duration is set to 60 seconds by default.
}
\details{
This transformation can be done for multiple columns with time-stamped data.
Use the `time_columns` argument to supply the names of one or more columns
that should be transformed.
}
