% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tAI.R
\name{nc.adj}
\alias{nc.adj}
\title{Adjusted effective number of codons (Nc)}
\usage{
nc.adj(nc, gc3)
}
\arguments{
\item{nc}{a vector of length n with the effective number of codons for genes}

\item{gc3}{a vector of length n with corresponding GC composition at third codon positions}
}
\value{
A vector of length n with adjusted Nc values
}
\description{
The adjusted Nc is f(gc3s) - Nc
}
\details{
The adjusted Nc is calculated as described in dos Reis et al. (2004).
}
\examples{

eco.ncadj <- nc.adj(ecolik12$w$Nc, ecolik12$w$GC3s)
plot(eco.ncadj ~ ecolik12$w$Nc, xlab="Nc", ylab="Nc adjusted")

}
\references{
dos Reis M., Savva R., and Wernisch L. (2004) Solving the riddle of codon 
usage preferences: a test for translational selection. \emph{Nucleic Acids Res.},
\bold{32:} 5036--44.
}
\seealso{
\code{\link{nc.f}} for the function used to calculate f(gc3s)
}
\author{
Mario dos Reis
}
