% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_create_survey}
\alias{sd_create_survey}
\title{Create a new survey template}
\usage{
sd_create_survey(template = "default", path = getwd(), ask = TRUE)
}
\arguments{
\item{template}{A character string specifying the template to use.
Default is "default" which uses the built-in package template.
Other options include:
\describe{
\item{default}{The default built-in template}
\item{conditional_showing}{Conditionally showing questions and pages}
\item{conditional_skipping}{Conditionally skipping to forward pages}
\item{conditional_stopping}{Conditionally stopping the navigation}
\item{conjoint_buttons}{Conjoint analysis with button interface}
\item{conjoint_tables}{Conjoint analysis with table interface}
\item{custom_leaflet_map}{Survey with interactive Leaflet maps}
\item{custom_plotly_chart}{Survey with Plotly visualizations}
\item{external_redirect}{Template with external site redirects}
\item{live_polling}{Live polling template for real-time surveys}
\item{question_types}{Showcases all available question types}
\item{questions_yml}{Survey with questions defined in a YAML file}
\item{random_options}{Survey with randomized question options}
\item{random_options_predefined}{Randomized options from predefined sets}
\item{reactive_drilldown}{Dynamic questions with drill-down capability}
\item{reactive_questions}{Survey with reactive questions}
}}

\item{path}{A character string specifying the directory where the survey
template should be created. Defaults to the current working directory.}

\item{ask}{Logical. If \code{TRUE} (default), prompts for user confirmation
when creating the survey in the current directory. If \code{FALSE}, bypasses
the confirmation prompt and proceeds without asking.}
}
\value{
Invisible \code{NULL}. The function is called for its side effects.
}
\description{
This function creates a new survey template by copying template files to the
specified directory. You can choose from various predefined templates,
including the default built-in template and specialized templates from the
surveydown-dev/templates repository.
}
\details{
When creating a new survey template, this function will:
\enumerate{
\item Check if the specified template is valid
\item Confirm the destination path with the user (if it's the current directory)
\item Download template files from GitHub if a non-default template is specified
\item Copy template files to the destination directory
\item Skip .Rproj files if one already exists in the destination
\item Prompt for confirmation before overwriting existing files
}

External templates are downloaded from the surveydown-dev/templates GitHub repository.
}
\examples{
if (interactive()) {
  # Create a survey with the "question_types" template in the "my_survey" directory
  sd_create_survey(template = "question_types", path = "my_survey")

  # Create a survey using the default template in the "my_survey" directory
  sd_create_survey(path = "my_survey")

  # Create a survey with default template in current directory
  sd_create_survey("default")

  # Create a survey without asking for confirmation
  sd_create_survey(template = "default", path = "my_survey", ask = FALSE)
}

}
