% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backhaz.R
\name{get_cum_backhaz}
\alias{get_cum_backhaz}
\title{Cumulative background hazards}
\usage{
get_cum_backhaz(t, backhaz, strata = NULL)
}
\arguments{
\item{t}{A time point, or vector of time points, to calculate the cumulative
hazard at.}

\item{backhaz}{A data frame with two columns, named \code{"time"} and
\code{"hazard"}. Each row gives the "background" hazard between the
specified time and the next time.}

\item{strata}{A vector of the same length as \code{t} indicating strata.
There should then be
\itemize{
\item a column in \code{backhaz} named \code{stratum}, which should
be a factor with the same levels as \code{strata} (or analogous
character vector).
\item a row in \code{backhaz} indicating the background hazard at each
time interval for each stratum in \code{strata}.
}

We assume that the background hazard is known at all times, and defined by
a piecewise-constant function (step function) of time. The first element of
\code{"time"} should be 0, and the final row specifies the hazard at all
times greater than the last element of \code{"time"}.

In additive hazards models, the background hazard is the hazard of
death from causes other than the specific cause of interest. The
overall hazard is defined as the sum of the background hazard and
the cause-specific hazard.  In \code{\link{survextrap}}, the
cause-specific hazard is modelled with the M-spline model, and
the background hazard is assumed to be known.}
}
\value{
The cumulative hazard at \code{t}.
}
\description{
Obtain the cumulative hazard at a particular time, given a data
frame of piecewise-constant background hazards.  This is used in
the computation of likelihoods and results in additive hazards
models.
}
\keyword{internal}
