% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_02.r
\name{crs.FP}
\alias{crs.FP}
\title{Penalty matrix constructor for cubic regression splines}
\usage{
crs.FP(knots, h)
}
\arguments{
\item{knots}{Numeric vectors that specifies the knots of the splines (including boundaries)}

\item{h}{vector of knots differences (corresponds to \code{diff(sort(knots))})}
}
\value{
List of two elements:
\item{F.mat}{matrix used in function \code{\link{crs}} for basis construction}
\item{P.mat}{penalty matrix}
}
\description{
constructs the penalty matrix associated with cubic regression splines basis. This function is called inside
\code{\link{crs}}.
}
\examples{

library(survPen)

# construction of the penalty matrix using a sequence of knots
knots <- c(0,0.25,0.5,0.75,1)
diff.knots <- diff(knots)

crs.FP(knots,diff.knots)

}
