% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCapillary.r
\name{calculateCapillary}
\alias{calculateCapillary}
\title{Calculate Capillary Balance}
\usage{
calculateCapillary(samples.table, plot.table, sq = 0, run = "", debug = FALSE)
}
\arguments{
\item{samples.table}{data frame containing at least the columns
'Sample.File', 'Sample.Name', 'Size.Standard', 'Instrument.Type',
'Instrument.ID', 'Cap', 'Well', and 'SQ'.}

\item{plot.table}{data frame containing at least the columns
'Sample.File.Name', 'Size', and 'Height'.}

\item{sq}{numeric threshold for 'Sizing Quality' (SQ).}

\item{run}{character string for run name.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Instrument', 'Instrument.ID', 'Run',
'Mean.Height', 'SQ', 'Injection', 'Capillary', 'Well', 'Comment'.
}
\description{
Calculates the ILS inter capillary balance.
}
\details{
Calculates the inter capillary balance for the internal lane standard (ILS).
Require information from both the 'samples.table' and the 'plot.table'.
}
