% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DST_Runner.R
\name{stream_pipeline}
\alias{stream_pipeline}
\alias{DST_Runner}
\title{Create a Data Stream Pipeline}
\usage{
DST_Runner(dsd, dst)
}
\arguments{
\item{dsd}{A data stream (subclass of \link{DSD}) typically provided using a \verb{\%>\%} (pipe).}

\item{dst}{A data stream mining task (subclass of \link{DST}).}
}
\description{
Define a complete data stream pipe line
consisting of a data stream, filters and a data mining task using \verb{\%>\%}.
}
\details{
A data stream pipe line
consisting of a data stream, filters and a data mining task:

\code{DSD \%>\% DSF \%>\% DST_Runner}

Once the pipeline is defined, it can be run using \code{\link[=update]{update()}} where points are
taken from the \link{DSD} data stream source,
filtered through a sequence of \link{DSF} filters and then used to update
the \link{DST} task.

\link{DST_Multi} can be used to update multiple models in the pipeline with the same stream.
}
\examples{
set.seed(1500)

# Set up a pipeline with a DSD data source, DSF Filters and then a DST task
cluster_pipeline <- DSD_Gaussians(k = 3, d = 2) \%>\%
                    DSF_Scale() \%>\%
                    DST_Runner(DSC_DBSTREAM(r = .3))

cluster_pipeline

# the DSD and DST can be accessed directly
cluster_pipeline$dsd
cluster_pipeline$dst

# update the DST using the pipeline, by default update returns the micro clusters
update(cluster_pipeline, n = 1000)

cluster_pipeline$dst
get_centers(cluster_pipeline$dst, type = "macro")
plot(cluster_pipeline$dst)
}
\seealso{
Other DST: 
\code{\link{DSAggregate}()},
\code{\link{DSC}()},
\code{\link{DSClassifier}()},
\code{\link{DSOutlier}()},
\code{\link{DSRegressor}()},
\code{\link{DST}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{update}()}
}
\author{
Michael Hahsler
}
\concept{DST}
