% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSClassifier_SlidingWindow.R
\name{DSClassifier_SlidingWindow}
\alias{DSClassifier_SlidingWindow}
\title{DSClassifier_SlidingWindow -- Data Stream Classifier Using a Sliding Window}
\usage{
DSClassifier_SlidingWindow(formula, model = rpart::rpart, window, rebuild, ...)
}
\arguments{
\item{formula}{a formula for the classification problem.}

\item{model}{classifier model (that has a formula interface).}

\item{window}{size of the sliding window.}

\item{rebuild}{interval (number of points) for rebuilding the classifier. Set rebuild to
\code{Inf} to prevent automatic rebuilding. Rebuilding can be initiated manually when
calling \code{update()}.}

\item{...}{additional parameters are passed on to the classifier (default is \code{\link[rpart:rpart]{rpart::rpart()}}).}
}
\value{
An object of class \code{DST_SlidingWindow}.
}
\description{
The classifier keeps a sliding window for the stream and rebuilds a classification model at regular
intervals. By default is builds a decision tree using \code{\link[rpart:rpart]{rpart::rpart()}}.
}
\details{
This constructor creates classifier based on \code{\link{DST_SlidingWindow}}. The classifier has
a \code{update()} and \code{predict()} method.
}
\examples{
library(stream)

# create a data stream for the iris dataset
data <- iris[sample(nrow(iris)), ]
stream <- DSD_Memory(data)

# define the stream classifier.
cl <- DSClassifier_SlidingWindow(
  Species ~ Sepal.Length + Sepal.Width + Petal.Length,
  window = 50,
  rebuild = 10
  )
cl

# update the classifier with 100 points from the stream
update(cl, stream, 100)

# predict the class for the next 50 points
newdata <- get_points(stream, n = 50)
pr <- predict(cl, newdata, type = "class")
pr

table(pr, newdata$Species)

# get the tree model
get_model(cl)
}
\seealso{
Other DSClassifier: 
\code{\link{DSClassifier}()}
}
\author{
Michael Hahsler
}
\concept{DSClassifier}
