## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(stratcols)

## ----fig.alt="A stratigraphic column with 3 facies"---------------------------
s = as_stratcol(thickness = runif(90), # random bed thicknesses
                facies = rep(c(1,2,3), 30)) # repeat facies 1, 2 and 3 
plot(s)

## -----------------------------------------------------------------------------
m = transition_matrix(s)
m

## -----------------------------------------------------------------------------
get_mom(m)

## -----------------------------------------------------------------------------
rom_observed = get_rom(s)
rom_observed

## ----fig.alt="Histogram of ROM values"----------------------------------------
n = 10000
rom_vals = rep(NA, n)
for (i in seq_len(n)){
  randomized_column = shuffle_col(s)
  rom_vals[i] = get_rom(randomized_column)
}

hist(rom_vals,
     main = "distribution of ROM values")
lines(x = rep(rom_observed, 2), y = c(0,n), col = "red")

## ----fig.alt="A stratigraphic column with randomly ordered beds"--------------
set.seed(1)
s = as_stratcol(thickness = runif(30), fa = rep(c(1,2,3), 10)) # uniform bed thickness, ordered facies
s = shuffle_col(s, allow_rep = TRUE) # randomize order of beds, allowing  for repetitions
plot(s)


## ----fig.alt="A stratigraphic column with beds with identical facies merged"----
s_merged = merge_beds(s, mode = "identical facies")
plot(s_merged)

## ----fig.alt="A stratigraphic column with ordered facies names"---------------
s_ord_names = order_facies_names(s_merged)
plot(s_ord_names)

## -----------------------------------------------------------------------------
m = transition_matrix(s_ord_names)
m

## -----------------------------------------------------------------------------
get_mom(m)

## ----eval=FALSE---------------------------------------------------------------
# 
# vignette("stratcols_doc")
# 

## ----eval=FALSE---------------------------------------------------------------
# vignette("stratcols")

