## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo = TRUE-------------------------------------------------------

library(stors)

# Optimize a proposal for the Normal distribution with 4091 steps
proposal <- srnorm_optimize(steps = 4091)

# Visualize the optimized proposal
plot(proposal)

## ----echo = TRUE--------------------------------------------------------------

# Generating 10 samples from the standard Normal distribution
standard_normal_samples <- srnorm(10, mean = 2, sd = 1)
print(standard_normal_samples)

## ----echo = TRUE--------------------------------------------------------------

# Optimize a custom proposal for N(3, 2)
proposal <- srnorm_optimize(mean = 3, sd = 2, steps = 2000)

# Generate a sample of size 10^3 from N(3, 2)
sample <- srnorm_custom(10^3)

# Visualize the generated sample
hist(sample, main = "Histogram of Samples from N(3, 2)", xlab = "Value", col = "skyblue", border = "white")



## ----echo = TRUE--------------------------------------------------------------

# Define the truncation bounds
lower_bound <- -1
upper_bound <- 1

# Optimize the scalable proposal with truncation bounds
proposal <- srnorm_optimize(xl = lower_bound, xr = upper_bound, steps = 4091)

# Generate samples from the truncated standard Normal distribution
sample <- srnorm(10^3)
hist(sample, main = "Truncated Standard Normal (-1, 1)", xlab = "Value", col = "lightblue", border = "white")

# Generate samples from the truncated Normal distribution N(2, 1)
sample <- srnorm(10^3, mean = 2)
hist(sample, main = "Truncated Normal N(2, 1) (-1, 1)", xlab = "Value", col = "lightgreen", border = "white")



## ----echo = TRUE--------------------------------------------------------------

# Define the truncation bounds
lower_bound <- 2
upper_bound <- 6

# Optimize a custom proposal with truncation bounds and mean = 4
proposal <- srnorm_optimize(mean = 4, xl = lower_bound, xr = upper_bound, steps = 4091)

# Generate samples from the truncated Normal distribution
sample <- srnorm_custom(10^3)
hist(sample, main = "Truncated Custom Normal (2, 6)", xlab = "Value", col = "lightblue", border = "white")



## ----echo = TRUE--------------------------------------------------------------

# Optimize a proposal for the Laplace distribution
proposal <- srlaplace_optimize(steps = 4091)

# View the details of the optimized proposal
print(proposal)

# Visualize the proposal
plot(proposal)


## ----echo = TRUE--------------------------------------------------------------

# Optimize a proposal for the Normal distribution
proposal <- srlaplace_optimize(steps = 1020)

# Visualize the entire proposal
plot(proposal, main = "Full Grid Visualization")

# Focus on a specific region of the proposal (e.g., x-axis range -2 to 2)
plot(proposal, x_min = -1, x_max = 1, main = "Zoomed-In Grid (-1, 1)")


## ----echo = TRUE--------------------------------------------------------------
# Customizing the proposal for a specific sample size
custom_proposal <- srnorm_optimize(target_sample_size = 10000)

print(custom_proposal)

plot(custom_proposal)

# Customizing the proposal with a specific pre-acceptance threshold
custom_proposal_high_theta <- srnorm_optimize(theta = 0.9)

print(custom_proposal_high_theta)

plot(custom_proposal_high_theta)

# Customizing the proposal within a specific range
custom_proposal_range <- srnorm_optimize(proposal_range = c(-1, 1))

print(custom_proposal_range)

plot(custom_proposal_range)


## ----echo = TRUE--------------------------------------------------------------
# Customizing the proposal with a specific number of steps
custom_proposal_steps <- srnorm_optimize(steps = 50)

plot(custom_proposal_steps)

custom_proposal_steps <- srnorm_optimize(steps = 500)

plot(custom_proposal_steps)


## ----echo = FALSE-------------------------------------------------------------

# Delete all non-symmetric proposals for the Normal distribution
delete_built_in_proposal(sampling_function = "srnorm", proposal_type = "scaled")
delete_built_in_proposal(sampling_function = "srnorm", proposal_type = "custom")

# Create a symmetric proposal for the standard Normal distribution
proposal <- srnorm_optimize(symmetric = TRUE, steps = 2040)

# Visualize the symmetric proposal
plot(proposal)


## ----echo = FALSE-------------------------------------------------------------

# Delete symmetric proposals for the Normal distribution
delete_built_in_proposal(sampling_function = "srnorm", proposal_type = "scaled")

# Optimize the proposal for a truncated standard Normal distribution
proposal <- srnorm_optimize(mean = 0, sd = 1, xl = -1, xr = 1, steps = 4020)

# Visualize the truncated proposal
plot(proposal, main = "Truncated Standard Normal Grid (-1, 1)", xlab = "Value", col = "lightblue")

# Generate 10^4 samples from the truncated distribution
sample <- srnorm_custom(10^4)

# Visualize the generated samples
hist(
  sample,
  main = "Histogram of Samples from Truncated Standard Normal",
  xlab = "Value",
  col = "lightgreen",
  border = "white"
)


## ----echo = FALSE-------------------------------------------------------------
name <- names(stors:::built_in_proposals)
formatted_names <- sprintf("{.fun %s_custom}", name)
cli::cli_ul(formatted_names)

for (name in names(stors:::built_in_proposals)) {
  fun_name <- paste0(name, "_optimize")
  do.call(fun_name, list(steps = 4091))
}

