% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{createForestDataset}
\alias{createForestDataset}
\title{Create ForestDataset Object}
\usage{
createForestDataset(covariates, basis = NULL, variance_weights = NULL)
}
\arguments{
\item{covariates}{Matrix of covariates}

\item{basis}{(Optional) Matrix of bases used to define a leaf regression}

\item{variance_weights}{(Optional) Vector of observation-specific variance weights}
}
\value{
\code{ForestDataset} object
}
\description{
Create a forest dataset object

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
covariate_matrix <- matrix(runif(10*100), ncol = 10)
basis_matrix <- matrix(rnorm(3*100), ncol = 3)
weight_vector <- rnorm(100)
forest_dataset <- createForestDataset(covariate_matrix)
forest_dataset <- createForestDataset(covariate_matrix, basis_matrix)
forest_dataset <- createForestDataset(covariate_matrix, basis_matrix, weight_vector)
}
