% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{createCppJsonString}
\alias{createCppJsonString}
\title{Create CppJson Object from String}
\usage{
createCppJsonString(json_string)
}
\arguments{
\item{json_string}{JSON string dump}
}
\value{
\code{CppJson} object
}
\description{
Create a C++ Json object from a Json string

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
example_vec <- runif(10)
example_json <- createCppJson()
example_json$add_vector("myvec", example_vec)
example_json_string <- example_json$return_json_string()
example_json_roundtrip <- createCppJsonString(example_json_string)
}
