#include <Rcpp.h>
#include <math.h>
#include <cmath>
#include "vmp_tpd.h"
#include "pi_range.h"


// [[Rcpp::plugins("cpp17")]]

// [[Rcpp::export]]

Rcpp::NumericVector sim_vmp_tpd(double length_sim, double theta_0, double dt, double mu, double lambda, double sigma){
  Rcpp::NumericVector theta (1, theta_0);
  double alpha_hat;
  alpha_hat = 2;
  double  alpha;
  alpha = 2;
  double rand_sim;
  Rcpp::NumericVector u_sample (0);
  while(theta.length()<length_sim){
    rand_sim = pi_range(R::rnorm(0,1));
    alpha = vmp_tpd(dt,rand_sim,theta_0,lambda,sigma,mu)/R::dnorm(rand_sim,0,1,FALSE);
    u_sample = Rcpp::runif(1);
    if(u_sample[0]<alpha/alpha_hat){
        theta.push_back(rand_sim);
    }
    alpha_hat = std::max(alpha,alpha_hat);
  }
  return theta;
}
