#include <Rcpp.h>
#include <math.h>
#include <cmath>
#include "cbm_tpd.h"
#include "s_given_rho_likelihood.h"

//' @export
// [[Rcpp::export]]

double optim_loop_cbm(double dt, Rcpp::NumericVector rho_vec, double sigma_wn,double nc,Rcpp::NumericVector S_1, Rcpp::NumericVector S_2, double mu1, double mu2, double sigma1, double sigma2){
  double ff{0};
  double n_constant;
  Rcpp::NumericVector V3 = {mu1,mu2};
  Rcpp::NumericVector V4 = {sigma1,sigma2};
  for(int j=0;j<nc-1;j++){
    Rcpp::NumericVector V1 = {S_1[j+1],S_2[j+1]};
    Rcpp::NumericVector V2 = {S_1[j],S_2[j]};
    ff = ff+s_given_rho_likelihood(dt,V1,V2,V3,V4,rho_vec[j+1])+log(2/sqrt(1-pow(rho_vec[j+1],2)))+log(cbm_tpd(dt,acos(rho_vec[j+1]),acos(rho_vec[j+1]),sigma_wn));
  }
  return(ff);
}
