% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_models.R
\name{evaluate_models}
\alias{evaluate_models}
\title{Evaluates multiple models with each predictor variable specified in different ways in order to determining model form}
\usage{
evaluate_models(
  input_data,
  target_var,
  model_family = "gaussian()",
  vars,
  coords_x = "X",
  coords_y = "Y",
  VC_type = "SVC",
  time_var = NULL,
  k_set = FALSE,
  spatial_k = 50,
  temporal_k = 10,
  k_increase = FALSE,
  k2edf_ratio = 1.5,
  k_multiplier = 2,
  max_iter = 10,
  ncores = 2
)
}
\arguments{
\item{input_data}{he data to be used used to create the GAM model in (\code{data.frame} or \code{tibble} format), containing an Intercept column to allow it be treated as an addressable term in the model.}

\item{target_var}{the name of the target variable.}

\item{model_family}{the mdoel family, defaults to Guassian}

\item{vars}{a vector of the predictor variable names (without the Intercept).}

\item{coords_x}{the name of the X, Easting or Longitude variable in \code{input_data}.}

\item{coords_y}{the name of the Y, Northing or Latitude variable in \code{input_data}.}

\item{VC_type}{the type of varying coefficient model: options are "TVC" for temporally varying, "SVC" for spatially varying  and "STVC" for space-time.}

\item{time_var}{the name of the time variable if undertaking STVC model evaluations.}

\item{k_set}{a logical value for user defined \code{k} values. The default is \code{FALSE}. Cannot be used with \code{k_increase}.}

\item{spatial_k}{the value of \code{k} for spatial smooths if \code{k_set} is \code{TRUE}.}

\item{temporal_k}{the value of \code{k} for temporal smooths if \code{k_set} is \code{TRUE}.}

\item{k_increase}{a logical value of whether to check and increase the number of knots in each smooth. The default is \code{FALSE}.}

\item{k2edf_ratio}{a threshold of the ratio of the number of knots, \code{k}, in each smooth to its Effective Degrees of Freedom. If any smooth has a \emph{knots-to-EDF} ratio less than this value then the knots are iteratively increased by the \code{k_multiplier} value until the threshold check is passed, the number knots passes the maximum degrees of freedom, or the number of iterations, \code{max_iter} is reached. Cannot be used with \code{k_set}.}

\item{k_multiplier}{a multiplier by which the knots are increased on each iteration. The default is 2.}

\item{max_iter}{the maximum number of iterations that \code{k} is increased.}

\item{ncores}{the number of cores to use in parallelised approaches (default is 2 to overcome CRAN package checks). This can be determined for your computer by running parallel::detectCores()-1. Parallel approaches are only undertaken if the number of models to evaluate is greater than 30.}
}
\value{
a \code{data.frame} with indices for each predictor variable, the knots specified in each smooth (\code{ks}), a AIC score (\code{aic}) for each model and the associated formula (\code{f}). The output should be passed to the \code{gam_model_rank} function.
}
\description{
Evaluates multiple models with each predictor variable specified in different ways in order to determining model form
}
\examples{
\dontrun{
require(dplyr)
require(doParallel)
require(sf)

# define input data
data("chaco")
input_data <-
  chaco |>
  # create Intercept as an addressable term
  mutate(Intercept = 1) |>
  # remove the geometry
  st_drop_geometry()

# evaluate different model forms
# example 1 with 6 models and no `k` adjustment
svc_mods <-
  evaluate_models(
    input_data = input_data,
    target_var = "ndvi",
    model_family = "gaussian()",
    vars = c("tmax"),
    coords_x = "X",
    coords_y = "Y",
    VC_type = "SVC"
  )
# have a look!
svc_mods

# example 2 with 6 models and `k` adjustment
svc_k1_mods <-
  evaluate_models(
    input_data = input_data,
    target_var = "ndvi",
    vars = c("tmax"),
    model_family = "gaussian()",
    coords_x = "X",
    coords_y = "Y",
    VC_type = "SVC",
    k_increase = TRUE,
    k2edf_ratio = 1.5,
    k_multiplier = 2,
    max_iter = 10
  )
# have a look!
svc_k1_mods

# example 3 with 6 models and `k` set by user
svc_k2_mods <-
  evaluate_models(
    input_data = input_data,
    model_family = "gaussian()",
    target_var = "ndvi",
    vars = c("tmax"),
    coords_x = "X",
    coords_y = "Y",
    VC_type = "SVC",
    time_var = NULL,
    k_set = TRUE,
    spatial_k = 20,
  )
# have a look!
svc_k2_mods
}

}
