% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyze}
\alias{analyze}
\title{Analyze a stepped wedge dataset}
\usage{
analyze(
  dat,
  method = "mixed",
  estimand_type = "TATE",
  estimand_time = c(1, attr(dat, "n_seq")),
  exp_time = "IT",
  cal_time = "categorical",
  family = stats::gaussian,
  re = c("clust", "time"),
  corstr = "exchangeable",
  offset = NULL
)
}
\arguments{
\item{dat}{A dataframe containing the stepped wedge trial data.}

\item{method}{A character string; either "mixed", for a mixed-effects model,
or "GEE", for generalized estimating equations.}

\item{estimand_type}{One of c("TATE", "PTE"); "TATE" represents the
time-averaged treatment effect and "PTE" represents the point treatment
effect.}

\item{estimand_time}{An integer vector of length 1 or 2. When
estimand_type="TATE", `estimand_time` must be a numeric vector of length
2, representing the start and end times of the exposure time period to
average over. When estimand_type="PTE", `estimand_time` must be a numeric
vector of length 1, representing the time period of interest. See
examples.}

\item{exp_time}{One of c("IT", "ETI", "NCS", "TEH"); model for exposure time.
"IT" encodes an immediate treatment model with a single treatment effect
parameter. "ETI" is an exposure time indicator model, including one
indicator variable for each exposure time point. "NCS" uses a natural
cubic spline model for the exposure time trend. "TEH" includes a random
slope term in the model, allowing the treatment effect to vary by
timepoint.}

\item{cal_time}{One of c("categorical", "NCS", "linear", "none"); model for
calendar time. "categorical" uses indicator variables for discrete time
points, as in the Hussey and Hughes model. "NCS" uses a natural cubic
spline, useful for datasets with continuous time. "linear" uses a single
slope parameter. "none" assumes that there is no underlying calendar time
trend.}

\item{family}{A family object; see documentation for `glm`.}

\item{re}{A character vector of random effects to include; only relevant if
method="mixed" is used. Possible random effects include "clust" (random
intercept for cluster), "time" (random intercept for cluster-time
interaction), "ind" (random intercept for individuals; appropriate when a
cohort design is used), "tx" (random treatment effect)}

\item{corstr}{One of c("independence", "exchangeable", "ar1"); only relevant
if method="GEE" is used. Defines the GEE working correlation structure;
see the documentation for `geepack::geeglm`.}

\item{offset}{A linear predictor offset term; see docs for `lme4::lmer`.}
}
\value{
A list with the model object, model type as a string, estimand type
as a string, numeric treatment effect estimate, numeric treatment effect standard error, and
treatment effect 95% confidence interval as a numeric vector of length 2
}
\description{
Analyze a stepped wedge dataset
}
\examples{
# Load data
test_data <- load_data(time ="period", cluster_id = "cluster", individual_id = NULL,
treatment = "trt", outcome = "outcome_cont", data = sw_data_example)

# Analysis example 1: TATE estimand for exposure times 1 through 4
results_tate <- analyze(dat = test_data, method = "mixed", estimand_type = "TATE",
estimand_time = c(1, 4), exp_time = "ETI")

results_tate

# Analysis example 2: PTE estimand for exposure time 3
results_pte <- analyze(dat = test_data, method = "mixed", estimand_type = "PTE",
estimand_time = 3, exp_time = "ETI")

results_pte

}
