% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{geolife_traj}
\alias{geolife_traj}
\title{GPS pings from the GeoLife GPS Trajectories dataset}
\format{
A \code{data.frame} with one row per ping and the following columns:
\itemize{
\item \code{date} (chr): The date
\item \code{time} (chr): The time
\item \code{x} (dbl): Longitude (EPSG:4586)
\item \code{y} (dbl): Latitude (EPSG:4586)
}
}
\source{
\url{https://www.microsoft.com/en-us/download/details.aspx?id=52367}
}
\usage{
geolife_traj
}
\description{
Extraction of the GeoLife GPS Trajectories dataset. The selected trajectory
id is 000-20081023025304.

Data manipulation applied to the raw data :
\itemize{
\item Conversion to EPSG:4586
\item Manual selection of the pings
\item Selection of relevant variables
}
}
\examples{
data(geolife_traj)
head(geolife_traj)
}
\keyword{datasets}
