% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_unexported.R
\name{.stabilize_cls_scalar}
\alias{.stabilize_cls_scalar}
\title{Stabilize a scalar object of a specific class}
\usage{
.stabilize_cls_scalar(
  x,
  to_cls_scalar_fn,
  ...,
  to_cls_scalar_args = list(),
  check_cls_value_fn = NULL,
  check_cls_value_fn_args = list(),
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{to_cls_scalar_fn}{\verb{(function)} The \verb{to_*_scalar()} function to use for
coercion.}

\item{...}{Arguments passed to methods.}

\item{to_cls_scalar_args}{\code{(list)} A list of additional arguments to pass to
\code{to_cls_scalar_fn()}.}

\item{check_cls_value_fn}{\verb{(function)} A function to check the values of \code{x}
after coercion.}

\item{check_cls_value_fn_args}{\code{(list)} A list of additional arguments to
pass to \code{check_cls_value_fn()}.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\value{
\code{x} as a scalar of the target class with all checks passed.
}
\description{
A helper used by the \verb{stabilize_*_scalar()} functions to provide a standard
set of checks.
}
\keyword{internal}
