% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-shared_params.R
\name{.shared-params}
\alias{.shared-params}
\title{Shared parameters}
\arguments{
\item{...}{Arguments passed to methods.}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}

\item{are_cls_ish_fn}{The \verb{are_*_ish} function to apply to each element.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{cast_fn}{\verb{(function)} The \verb{as.*()} function to use for coercion.}

\item{check_cls_value_fn}{\verb{(function)} A function to check the values of \code{x}
after coercion.}

\item{check_cls_value_fn_args}{\code{(list)} A list of additional arguments to
pass to \code{check_cls_value_fn()}.}

\item{coerce_character}{\verb{(length-1 logical)} Should character vectors such as
"1" and "2.0" be considered numeric-ish?}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{depth}{\verb{(length-1 integer)} Current recursion depth. Do not manually
set this parameter.}

\item{is_rlang_cls_scalar}{\verb{(function)} An \verb{is_scalar_*()} function from
rlang, used for a fast path if \code{x} is already the right type.}

\item{levels}{\code{(character)} The desired factor levels.}

\item{message_env}{(\code{environment}) The execution environment to use to
evaluate variables in error messages.}

\item{min_size}{\verb{(length-1 integer)} The minimum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{min_value}{\verb{(length-1 numeric)} The lowest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{max_size}{\verb{(length-1 integer)} The maximum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_value}{\verb{(length-1 numeric)} The highest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{parent}{A parent condition, as you might create during a
\code{\link[rlang:try_fetch]{rlang::try_fetch()}}. See \code{\link[rlang:abort]{rlang::abort()}} for additional information.}

\item{regex}{\verb{(character, list, or stringr_pattern)} One or more optional
regular expressions to test against the values of \code{x}. This can be a
character vector, a list of character vectors, or a pattern object from the
\{stringr\} package (e.g., \code{stringr::fixed("a.b")}). The default error
message for non-matching values will include the pattern itself (see
\code{\link[=regex_must_match]{regex_must_match()}}). To provide a custom message, supply a named
character vector where the value is the regex pattern and the name is the
message that should be displayed. To check that a pattern is \emph{not} matched,
attach a \code{negate} attribute set to \code{TRUE}. If a complex regex pattern
throws an error, try installing the stringi package.}

\item{subclass}{(\code{character}) Class(es) to assign to the error. Will be
prefixed by "stbl-error-".}

\item{to_class}{\verb{(length-1 character)} The name of the class to coerce to.}

\item{to_cls_args}{\code{(list)} A list of additional arguments to pass to
\code{to_cls_fn()}.}

\item{to_cls_fn}{\verb{(function)} The \verb{to_*()} function to use for coercion.}

\item{to_cls_scalar_args}{\code{(list)} A list of additional arguments to pass to
\code{to_cls_scalar_fn()}.}

\item{to_cls_scalar_fn}{\verb{(function)} The \verb{to_*_scalar()} function to use for
coercion.}

\item{to_na}{\code{(character)} Values to convert to \code{NA}.}

\item{to_type_obj}{An empty object of the target type (e.g., \code{integer()}).}

\item{x}{The argument to stabilize.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\description{
These parameters are used in multiple functions. They are defined here to
make them easier to import and to find.
}
\keyword{internal}
