% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_vehicles}
\alias{read_vehicles}
\title{Read in stats19 road safety data from .csv files downloaded.}
\usage{
read_vehicles(
  year = NULL,
  filename = "",
  data_dir = get_data_directory(),
  format = TRUE
)
}
\arguments{
\item{year}{Single year for which data are to be read}

\item{filename}{Character string of the filename of the .csv to read, if this is given, type and
years determine whether there is a target to read, otherwise disk scan would be needed.}

\item{data_dir}{Where sets of downloaded data would be found.}

\item{format}{Switch to return raw read from file, default is \code{TRUE}.}
}
\description{
Read in stats19 road safety data from .csv files downloaded.
}
\section{Details}{

The function returns a data frame, in which each record is a reported vehicle in the
STATS19 dataset for the data_dir and filename provided.
}

\examples{
\donttest{
if(curl::has_internet()) {
dl_stats19(year = 2024, type = "vehicle")
ve = read_vehicles(year = 2024)
}
}
}
