% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{test.prop.bs}
\alias{test.prop.bs}
\title{Hypothesis test of equal proportions in a between-subjects design}
\usage{
test.prop.bs(f, n)
}
\arguments{
\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Chi-square - chi-square test statistic
\item df - degrees of freedom
\item p - p-value
}
}
\description{
Computes a Pearson chi-square test for equal population proportions for a
dichotomous response variable in a one-factor between-subjects design.

For more details, see Section 2.13 of Bonett (2021, Volume 3)
}
\examples{
f <- c(111, 118, 132)
n <- c(200, 200, 200)
test.prop.bs (f, n)

# Should return:
# Chi-square df       p
#     4.7706  2 0.09206


}
\references{
\insertRef{Fleiss2003}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
