% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.median.bs}
\alias{size.ci.lc.median.bs}
\title{Sample size for a between-subjects median linear contrast confidence interval}
\usage{
size.ci.lc.median.bs(alpha, var, w, v, dist)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{w}{desired confidence interval width}

\item{v}{vector of between-subjects contrast coefficients}

\item{dist}{\itemize{
\item set to 1 for Normal distribution (skew = 0, kurtosis = 3)
\item set to 2 for Logistic distribution (skew = 0, kurtosis = 4.2)
\item set to 3 for Laplace distribution (skew = 0, kurtosis = 6)
\item set to 4 for Gamma(5) (skew = .89, kurtosis = 4.2)
\item set to 5 for Exponential distribution (skew = 2, kurtosis = 9)
}}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to estimate a linear contrast of population medians with desired
confidence interval precision in a between-subjects design. Set the
variance planning value to the largest value within a plausible range
for a conservatively large sample size. The sample size requirement depends
on the shape of the distribution. Select one of the four distribution
options (Normal, Logistic, Laplace, Exponential) that approximates the most
likely distribution shape in the planned study. Select the Normal
distribution for a conservatively large sample size requirement.

For more details, see Sections 1.28 and 3.24 of Bonett (2021, Volume 1)
}
\examples{
v <- c(.5, .5, -1)
size.ci.lc.median.bs(.05, 5.62, 2.0, v, 1)

# Should return:
# Sample size per group
#                    51

size.ci.lc.median.bs(.05, 5.62, 2.0, v, 4)

# Should return:
# Sample size per group
#                    33
 

}
\references{
\insertRef{Bonett2002}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
