% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.stdmean.ps}
\alias{ci.stdmean.ps}
\title{Confidence intervals for a paired-samples standardized mean difference}
\usage{
ci.stdmean.ps(alpha, m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for measurement 1}

\item{m2}{estimated mean for measurement 2}

\item{sd1}{estimated standard deviation for measurement 1}

\item{sd2}{estimated standard deviation for measurement 2}

\item{cor}{estimated correlation between measurements}

\item{n}{sample size}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item Estimate - estimated standardized mean difference
\item adj Estimate - bias adjusted standardized mean difference estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized mean difference
in a paired-samples design. A square root unweighted variance standardizer
and single measurement standard deviation standardizers are used. Equality
of variances is not assumed.

For more details, see Section 4.3 of Bonett (2021, Volume 1)
}
\examples{
ci.stdmean.ps(.05, 602.4, 705.6, 33.17, 51.08, .769, 8)

# Should return:
#                             Estimate adj Estimate      SE      LL      UL
# Unweighted standardizer:     -2.3963      -2.2185 0.65209 -3.6744 -1.1182
# Measurement 1 standardizer:  -3.1112      -2.7656 0.91362 -4.9019 -1.3206
# Measurement 2 standardizer:  -2.0204      -1.7959 0.59328 -3.1832 -0.8576


}
\references{
\insertRef{Bonett2008}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
