% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.slope.prop.bs}
\alias{ci.slope.prop.bs}
\title{Confidence interval for a slope of a proportion in a single-factor
experimental design with a quantitative between-subjects factor}
\usage{
ci.slope.prop.bs(alpha, f, n, x)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}

\item{x}{vector of quantitative factor values}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted slope estimate
\item SE - adjusted standard error
\item z - z test statistic
\item p - two-sided p-value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes a test statistic and an adjusted Wald confidence interval for the
population slope of proportions in a one-factor experimental design with a
quantitative between-subjects factor.

For more details, see Section 4.4 of Bonett (2021, Volume 3)
}
\examples{
f <- c(11, 15, 20, 27)
n <- c(60, 60, 60, 60)
x <- c(10, 20, 30, 40)
ci.slope.prop.bs(.05, f, n, x)

# Should return:
#    Estimate          SE      z       p          LL         UL
# 0.008688525 0.002566409 3.3855 0.00071 0.003658456 0.01371859


}
\references{
\insertRef{Price2004}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
