% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.median2}
\alias{ci.ratio.median2}
\title{Confidence interval for a 2-group median ratio}
\usage{
ci.ratio.median2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for group 1
\item Median2 - estimated median for group 2
\item Median1/Median2 - estimated ratio of medians
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a ratio of population
medians of ratio-scale measurements in a 2-group design. Tied scores
within each group are assumed to be rare.

For more details, see Section 2.12 of Bonett (2021, Volume 1)
}
\examples{
y2 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29, 49, 42, 40)
y1 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
ci.ratio.median2(.05, y1, y2)

# Should return:
# Median1 Median2 Median1/Median2       LL       UL
#      43      37        1.162162 0.927667 1.455933


}
\references{
\insertRef{Bonett2020b}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
