% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median2}
\alias{ci.median2}
\title{Confidence interval for a 2-group median difference}
\usage{
ci.median2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for group 1
\item Median2 - estimated median for group 2
\item Median1-Median2 - estimated difference of medians
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a difference of population
medians in a 2-group design. Tied scores within each group are assumed to be
rare.

For more details, see Section 2.12 of Bonett (2021, Volume 1)
}
\examples{
y1 = c(70, 394, 43, 95, 62, 128, 2, 203, 81, 436, 85, 35, 
        156, 1, 3, 27, 63, 181, 184, 18)
y2 = c(102, 120, 78, 78, 417, 124, 86, 171, 176, 129, 230, 
       194, 100, 157, 306, 411, 164, 103, 193, 312)
ci.median2(.05, y1, y2)

# Should return:
#  Median1 Median2 Median1-Median2       SE        LL        UL
#     75.5   160.5             -85 37.11502 -157.7441 -12.25589


}
\references{
\insertRef{Bonett2002}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
